<?php

function generate_pdf($name, $templatePath, $outputPath)
{
    require_once ROOTPATH . 'vendor/autoload.php';

    $dompdf = new \Dompdf\Dompdf();
    $dompdf->loadHtmlFile($templatePath);
    $dompdf->setPaper('A4', 'portrait');

    // Generate the greeting HTML with the name
    $html = '<div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%);">';
    $html .= '<p style="text-align: center; font-size: 20px;">Hello, ' . $name . '!</p>';
    $html .= '</div>';

    // Insert the greeting HTML into the template PDF
    $canvas = $dompdf->getCanvas();
    $dompdf->getCanvas()->page_text(10, 10, $html, null, 10, array(0, 0, 0));

    $dompdf->render();

    // Save the generated PDF to the specified output path
    $output = $dompdf->output();
    file_put_contents($outputPath, $output);
}
