<?php

namespace App\Controllers;
use TCPDF;
use setasign\Fpdi\Tcpdf\Fpdi;

class Home extends BaseController
{

	public function index()
	{
		$data['title'] = 'الصفحة الرئيسية';

		$data['page'] = view('Home/index', $data);

		return view('layouts/default', $data);
	}

    public function safwah()
	{
		$data['title'] = 'فندق الصفوة';

		$data['page'] = view('Home/safwah', $data);

		return view('layouts/default', $data);
	}

//  public function generatePDF()
//  {
//      $name = $this->request->getPost('name');
//      $templatePath = FCPATH . 'uploads/files/greetings.pdf';
//      $outputFilename = uniqid('greeting_') . '.pdf';
//      $outputPath = FCPATH . 'uploads/files/' . $outputFilename;
//      $pdfWidth = 1080;
//      $pdfHeight = 1080;
//      $pdf = new TCPDF('L', 'mm', [$pdfWidth, $pdfHeight], true, 'UTF-8', false);
//      $pdf->SetTitle('Greeting PDF');
//      $pdf->AddPage();
//      $pdf->SetFont('dejavusans', '', 55, '', true);
//      $pdf->setRTL(true);
//      $nameWidth = $pdf->GetStringWidth($name);
//      $nameX = ($pdfWidth - $nameWidth) / 2;
//      $nameY = $pdfHeight / 2;
//      $pdf->SetXY($nameX, $nameY);
//      $pdf->Write(0, $name);
//      $pdf->Output($outputPath, 'F');
//      return $this->response->download($outputPath, null);
//  }
    
public function generatePDF()
{
    $name = $this->request->getPost('name');
    $templatePath = FCPATH . 'uploads/files/greetings.pdf';
    $outputFilename = uniqid('greeting_') . '.pdf';
    $outputPath = FCPATH . 'uploads/files/' . $outputFilename;
    $pdf = new Fpdi();
    $pdf->AddPage();
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('dejavusans', '', 110);
    $nameWidth = $pdf->GetStringWidth($name);
    $pdf->setSourceFile($templatePath);
    $templateId = $pdf->importPage(1);
    $templateWidth = 381;
    $templateHeight = 381;
    $templateWidthInPoints = ($templateWidth / 25.4) * 72;
    $templateHeightInPoints = ($templateHeight / 25.4) * 72;
    $pdf->useTemplate($templateId, [
        'adjustPageSize' => true,
        'width' => $templateWidthInPoints,
        'height' => $templateHeightInPoints,
    ]);
    $pdfWidth = $pdf->GetPageWidth();
    $pdfHeight = $pdf->GetPageHeight();
    $nameX = ($pdfWidth - $nameWidth) / 2;
    $nameY = ($pdfHeight - 55) / 1.45;
    $pdf->SetXY($nameX, $nameY);
    $pdf->Write(0, $name);
    $pdf->Output($outputPath, 'F');
    return $this->response->download($outputPath, null);
}
public function generatePDFs()
{
    $name = $this->request->getPost('name');
    $templatePath = FCPATH . 'uploads/files/greetingsS.pdf';
    $outputFilename = uniqid('greeting_') . '.pdf';
    $outputPath = FCPATH . 'uploads/files/' . $outputFilename;
    $pdf = new Fpdi();
    $pdf->AddPage();
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('dejavusans', '', 110);
    $nameWidth = $pdf->GetStringWidth($name);
    $pdf->setSourceFile($templatePath);
    $templateId = $pdf->importPage(1);
    $templateWidth = 352.8;
    $templateHeight = 544.7;
    $templateWidthInPoints = ($templateWidth / 25.4) * 72;
    $templateHeightInPoints = ($templateHeight / 25.4) * 72;
    $pdf->useTemplate($templateId, [
        'adjustPageSize' => true,
        'width' => $templateWidthInPoints,
        'height' => $templateHeightInPoints,
    ]);
    $pdfWidth = $pdf->GetPageWidth();
    $pdfHeight = $pdf->GetPageHeight();
    $nameX = ($pdfWidth - $nameWidth) / 2;
    $nameY = ($pdfHeight - 55) / 1.53;
    $pdf->SetXY($nameX, $nameY);
    $pdf->Write(0, $name);
    $pdf->Output($outputPath, 'F');
    return $this->response->download($outputPath, null);
}

}